<?php $__env->startSection('seo_title', $portfolio->seo_title); ?>
<?php $__env->startSection('seo_meta_description', $portfolio->seo_meta_description); ?>

<?php $__env->startSection('content'); ?>
<section class="page-title" style="background-image: url(<?php echo e(asset('uploads/'.$global_setting->banner)); ?>);">
    <div class="auto-container">
        <div class="title-outer">
            <h1 class="title"><?php echo e($portfolio->name); ?></h1>
            <ul class="page-breadcrumb">
                <li><a href="<?php echo e(route('home')); ?>"><?php echo e(__('Home')); ?></a></li>
                <li><a href="<?php echo e(route('portfolios')); ?>"><?php echo e($global_other_page_items->page_portfolios_title); ?></a></li>
                <li><?php echo e($portfolio->name); ?></li>
            </ul>
        </div>
    </div>
</section>
<section class="project-details">
    <div class="container">
        <div class="row">
            <div class="col-xl-12">
                <div class="project-details__top">
                    <div class="project-details__img">
                        <img src="<?php echo e(asset('uploads/'.$portfolio->banner)); ?>" alt="<?php echo e($portfolio->name); ?>">
                    </div>
                </div>
            </div>
        </div>
        <div class="row justify-content-center">
            <div class="col-xl-10">
                <div class="project-details__content-right">
                    <div class="project-details__details-box">
                        <div class="row">
                            <div class="col">
                                <p class="project-details__client"><?php echo e(__('Date')); ?></p>
                                <h4 class="project-details__name"><?php echo e($portfolio->date); ?></h4>
                            </div>
                            <div class="col">
                                <p class="project-details__client"><?php echo e(__('Client')); ?></p>
                                <h4 class="project-details__name"><?php echo e($portfolio->client); ?></h4>
                            </div>
                            <div class="col">
                                <p class="project-details__client"><?php echo e(__('Website')); ?></p>
                                <h4 class="project-details__name"><?php echo e($portfolio->website); ?></h4>
                            </div>
                            <div class="col">
                                <p class="project-details__client"><?php echo e(__('Location')); ?></p>
                                <h4 class="project-details__name"><?php echo e($portfolio->location); ?></h4>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="project-details__content">
            <div class="row">
                <div class="col-xl-12">
                    <div class="project-details__content-left">
                        <h3 class="mb-4 mt-5"><?php echo e(__('About this project')); ?></h3>
                        <p>
                            <?php echo clean($portfolio->description); ?>

                        </p>
                    </div>
                </div>
            </div>
        </div>
        <div class="row">
            <div class="col-xl-12">
                <div class="project-details__pagination-box">
                    <ul class="project-details__pagination list-unstyled clearfix">
                        <li class="next">
                            <div class="icon">
                                <?php if($previous_slug == ''): ?>
                                <a href="javascript:;" aria-label="Previous"><i class="lnr lnr-icon-arrow-left"></i></a>
                                <?php else: ?>
                                <a href="<?php echo e(route('portfolio',$previous_slug)); ?>" aria-label="Previous"><i class="lnr lnr-icon-arrow-left"></i></a>
                                <?php endif; ?>
                            </div>
                            <div class="content"><?php echo e(__('Previous')); ?></div>
                        </li>
                        <li class="count"><a href="#"></a></li>
                        <li class="count"><a href="#"></a></li>
                        <li class="count"><a href="#"></a></li>
                        <li class="count"><a href="#"></a></li>
                        <li class="previous">
                            <div class="content"><?php echo e(__('Next')); ?></div>
                            <div class="icon">
                                <?php if($next_slug == ''): ?>
                                <a href="javascript:;" aria-label="Previous"><i class="lnr lnr-icon-arrow-right"></i></a>
                                <?php else: ?>
                                <a href="<?php echo e(route('portfolio',$next_slug)); ?>" aria-label="Previous"><i class="lnr lnr-icon-arrow-right"></i></a>
                                <?php endif; ?>
                            </div>
                        </li>
                    </ul>
                </div>
            </div>
        </div>
    </div>
</section>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('front.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/avantcom/knuckleball.avantcommunications.co.ke/resources/views/front/portfolio.blade.php ENDPATH**/ ?>